/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "CExample.h"
#include "ISectionDialog.h"

#include "CISection.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern IHelm *pHelm;
extern IApplication *pdApp;

/////////////////////////////////////////////////////////////////////////////
// CISectionDialog dialog


CISectionDialog::CISectionDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CISectionDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISectionDialog)
	m_iHorizontalThickness = 50;
	m_iVerticalThickness = 50;
	m_iLength = 100;
	m_iWidth = 100;
	m_iExtHeight = 100;
	m_blendRadius = 5;
	m_check1 = TRUE;
	//}}AFX_DATA_INIT
}


void CISectionDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISectionDialog)
	DDX_Text(pDX, IDC_IEDIT1, m_iHorizontalThickness);
	DDX_Text(pDX, IDC_IEDIT2, m_iVerticalThickness);
	DDX_Text(pDX, IDC_IEDIT3, m_iLength);
	DDX_Text(pDX, IDC_IEDIT4, m_iWidth);
	DDX_Text(pDX, IDC_IEDIT5, m_iExtHeight);
	DDX_Text(pDX, IDC_IEDIT6, m_blendRadius);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CISectionDialog, CDialog)
	//{{AFX_MSG_MAP(CISectionDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISectionDialog message handlers

void CISectionDialog::OnOK() 
{
	HRESULT hr = S_OK;
	pHelm = NULL;
	
	if (!pdApp) {
		AfxMessageBox("Unable to get Application");
		CDialog::OnOK();
		return;
	}
	// Taking the helm
	hr = pdApp->TakeHelm(&pHelm);
	if (hr) {
		AfxMessageBox("Failed to GetHelm");
		return;
	}

	ISet *objSet1 = NULL;
	UpdateData(TRUE);
	if (!m_check1)
		m_blendRadius = 0.0;

	if (m_iLength > 0 && m_iVerticalThickness > 0 && m_iHorizontalThickness > 0
		&& m_iWidth > 0 && m_iExtHeight > 0
		&& m_iVerticalThickness < m_iLength && m_iVerticalThickness < m_iWidth
		&& m_iHorizontalThickness < m_iLength && m_iHorizontalThickness < m_iWidth) {
		
		hr = CreateISection(m_iLength / 1000, m_iVerticalThickness / 1000,
			m_iHorizontalThickness / 1000, m_iWidth / 1000, m_iExtHeight / 1000, m_blendRadius / 1000, &objSet1);
		if (FAILED(hr) || !objSet1) {
			AfxMessageBox("CreateISection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");

	hr = pHelm->Release();

	CDialog::OnOK();
}

void CISectionDialog::OnCancel() 
{
	CDialog::OnCancel();
}
